IF EXISTS (select * from sysobjects where name like '%T_Insert_WM_Zona%')
DROP TRIGGER T_Insert_WM_Zona
go

CREATE TRIGGER T_Insert_WM_Zona
ON  WM_Zona
FOR INSERT, UPDATE
AS
	DECLARE @IdZona DECIMAL(20,0);

	DECLARE Elems_Cursor_Insert_WMZ CURSOR FOR
	SELECT IdZona FROM INSERTED;
	OPEN Elems_Cursor_Insert_WMZ

	FETCH NEXT FROM Elems_Cursor_Insert_WMZ INTO @IdZona
	WHILE @@FETCH_STATUS = 0
	BEGIN	

		PRINT 'Ejecucion trigger T_Insert_WM_Zona. ' + CONVERT(VARCHAR(200), @IdZona);
		EXEC Procedure_AtributosDerivadosWM_Zona @IdZona;

	FETCH NEXT FROM Elems_Cursor_Insert_WMZ INTO @IdZona
	END

	CLOSE Elems_Cursor_Insert_WMZ
	DEALLOCATE Elems_Cursor_Insert_WMZ
		

GO
ALTER TABLE WM_Zona ENABLE TRIGGER T_Insert_WM_Zona
GO